function [s,SL,SU]=Gorza(A,B)

%
% [s,SL,SU]=Gorza(A,B)
%
% To compute the similarity between two IT2 FSs A and B using Gorzalczany's
% method:
% 
%  M. B. Gorzalczany, "A method of inference in approximate reasoning based on
%  interval-valued fuzzy sets," Fuzzy Sets and Systems, vol. 21, pp. 1--17, 1987.
%
% Dongrui WU (dongruiw@usc.edu), 7/9/2008
%
% A, B: IT2 FSs each defined by nine parameters (see Fig. 1 in Readme.doc)

N=200; % number of discretizations
minX=min(A(1),B(1)); % the range
maxX=max(A(4),B(4));
X=linspace(minX,maxX,N);

lowerA=mg(X,A(5:8),[0 A([9 9]) 0]);
upperA=mg(X,A(1:4));
lowerB=mg(X,B(5:8),[0 B([9 9]) 0]);
upperB=mg(X,B(1:4));

SL=max(min([lowerA;lowerB]))/A(9);
SU=max(min([upperA;upperB]));
s=(SL+SU)/2;

